*Counterfactual between-class inequality levels

*Tim Goedemé, 28/10/2020
*This version 1: no interaction terms with social class; all cases with non-missing values included.

*This version is not used in the Social Indicators Research article.


/*

Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. 
This file can be changed and re-shared for non-commercial use, as long as our original work 
is recognised and the revised work is made available under the same conditions.

When using this do-file, please cite as:
Goedemé, T., Nolan, B., Paskov, M., & Weisstanner, D. (2021). 
Occupational Social Class and Earnings Inequality in Europe: A Comparative Assessment. 
In: Social Indicators Research. DOI: https://doi.org/10.1007/s11205-021-02746-z; https://timgoedeme.com/tools/esec-in-eu-silc/

This file makes use of the subprop command, which I wrote but is not available online.
Please contact me in case you would like to have access to this command.

*/

*Globals

global place1 <<data directory ...\2020-04\ >>
global place2 <<output directory ...\Estimations\Regs\ >>
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IT LT LU LV MT NL NO PL PT RO RS SE SI UK


*Estimating the counterfactual between-class MLD; only SILC 2018 - 9 classes
set matsize 5000, permanent


foreach ctry of global countries {
	di "`ctry'", _continue
	cap mat drop results	
	quietly {
		local year 2018
		cap use "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars1.dta", clear
		if _rc==0 {
			drop age hydisp eqs hystd thresh60 arop60 actage active
			svyset psu1 [pw=weight], strata(strata1)
			
			replace sub = 0 if missers!=0
			replace sub = 0 if earns1<=0 | earns2<=0
			
			gen class=esec08
			drop esec08
			subprop3 class, subpop(sub) na(test)
			local rows=rowsof(test)
			local secondterm
			forvalues x=1/`rows' {
				local c=el(test, `x', 1)
				local s=el(test, `x', 2)/100
				local secondterm `secondterm' -`s'*ln(_b[`c'.class])
				
			}
			
			cap mat drop results_`ctry' 
			local conflevel 0.025
			forvalues earnings = 1/2 {
				global vars c.fyfte i.sex i.immigrant i.education i.disabled i.health i.sector i.temporary c.career i.single i.oneearner i.singleparent i.breadwinner i.othernochild i.otherwchild
								
				/*1. Version 1: with interaction terms
				*************************************
				noi di "`earnings':1", _continue

				global interactions
				foreach var of global vars {
					global interactions ${interactions} i.class#`var' 
				}
				
				svy, subpop(sub): reg earns`earnings' i.class ${vars} ${interactions}
				estimates store `ctry'_`earnings'_1
				
				margins i.class, atmeans post subpop(if sub==1) grand // by adding 'grand' the counterfactual average is computed
				
				nlcom ln(_b[_cons]) `secondterm'
				
				local estimate=el(r(b), 1, 1)
				local SE=(el(r(V),1,1)^0.5)
				local DF=e(df_r)
				local LB=`estimate'+ (-1)*(invttail(`DF', `conflevel')*`SE')
				local UB=`estimate'+ (invttail(`DF', `conflevel')*`SE')
				mat def results_`ctry' = `earnings', 1, `estimate', `SE', `DF', `LB', `UB' */

				*2. Version 2: without interaction terms
				****************************************
				noi di "`earnings':2", _continue
								
				svy, subpop(sub): reg earns`earnings' i.class ${vars}
				estimates store `ctry'_`earnings'_2
				
				margins i.class, atmeans post subpop(if sub==1) grand // by adding 'grand' the counterfactual average is computed
				
				nlcom ln(_b[_cons]) `secondterm'
				
				local estimate=el(r(b), 1, 1)
				local SE=(el(r(V),1,1)^0.5)
				local DF=e(df_r)
				local LB=`estimate'+ (-1)*(invttail(`DF', `conflevel')*`SE')
				local UB=`estimate'+ (invttail(`DF', `conflevel')*`SE')
				mat def results_`ctry' = nullmat(results_`ctry') \ `earnings', 2, `estimate', `SE', `DF', `LB', `UB'

			
			}
			
			
			noi di "."
			
		}
		*Write results to files
		***********************
		mat colnames results_`ctry' = earnings interact est se df lb ub
		mat li results_`ctry'
		clear
		svmat results_`ctry', names(matcol)
		gen country="`ctry'"
				
		save "${place2}\MLD_decomp1_`ctry'_esec9.dta", replace // esec08
		
		estout `ctry'_1_2 `ctry'_2_2 using "${place2}\Regs_23_Version1_`ctry'_coefs.txt", cells("b se p") stats(df_r r2) replace
		*estout `ctry'_1_1 `ctry'_1_2 `ctry'_2_1 `ctry'_2_2 using "${place2}\Regs_23_Version1_`ctry'_coefs.txt", cells("b se p") stats(df_r r2) replace
	}
}

